// SBPropertyChangerV2, Aug 2024, SeriousBarbie AT barbies DOT world
// Changes the given properties of one or multiple *WantedActor*.
class SBPropertyChanger expands Triggers;



var name	NameConversionHack; // to convert String -> Name

var(PropertyChanger) bool bDebug;
var(PropertyChanger) name WantedActor;
var(PropertyChanger) String Properties[8]; // Properties to change
var(PropertyChanger) String PropertyValues[8]; // their values
var(PropertyChanger) bool bTriggerOnceOnly;
var(PropertyChanger) enum EWantedActorSearchBy // Should the *WantedActor* searched by Name or by Tag?
{
	WASB_Name,
	WASB_Tag
} WantedActorSearchBy;



function DebugOutput() {
local byte i, PropertiesCount;

	DebugLog("DebugOutput", "Tag='" $ Tag $ "'");
	DebugLog("DebugOutput", "Event='" $ Event $ "'");
	DebugLog("DebugOutput", "WantedActor='" $ WantedActor $ "'");
	DebugLog("DebugOutput", "bTriggerOnceOnly=" $ bTriggerOnceOnly);
	DebugLog("DebugOutput", "EWantedActorSearchBy=" $ String(GetEnum(enum'EWantedActorSearchBy', WantedActorSearchBy)));
	for (i = 0; i < ArrayCount(Properties); i++)
		if (Properties[i] != "")
			PropertiesCount++;
	DebugLog("DebugOutput", "PropertiesCount=" $ PropertiesCount);

	for (i = 0; i < ArrayCount(Properties); i++)
		if (Properties[i] != "")
			DebugLog("DebugOutput", "Properties[" $ i $ "]='" $ Properties[i] $ "', PropertyValue='" $ PropertyValues[i] $ "'");
}



function DebugLog(string FunctionName, string msg) {
	log(self $ "." $ FunctionName $ ":" @ msg);
}



function name StringToName(string str) {
	SetPropertyText("NameConversionHack", str);
	if (bDebug) DebugLog("StringToName", "converting string '" $ str $ "' to name '" $ NameConversionHack $ "'");
	return NameConversionHack;
}



function Trigger(actor Other, pawn EventInstigator) {
	if (bDebug) DebugLog("Trigger", "event received from" @ Other $ ", EventInstigator=" $ EventInstigator);
	Instigator = EventInstigator;
	gotostate('ChangeProperties');
}



function bool FindActorByName(name ActorName, out Actor FoundActor, optional name ActorTag) {
local Actor A;

	foreach AllActors(class'Actor', A, ActorTag)
		if (A.Name == ActorName)
		{
			FoundActor = A;
			if (bDebug) DebugLog("FindActorByName", "found" @ FoundActor);
			return true;
		}
	warn("Actor '" $ ActorName $ "' with Tag='" $ ActorTag $ "' not found");
	return false;
}



function bool SplitByComma(string s, out string OutStr1, out string OutStr2) {
local int i;

	i = InStr(s, ",");
	if (i >= 0)
	{
		OutStr1 = left(s, i);
		OutStr2 = right(s, Len(s) - i - 1);
	}
	else
		OutStr1 = s;
	if (bDebug) DebugLog("SplitByComma", "incoming string='" $ s $ "' splitted to '" $ OutStr1 $ "' and '" $ OutStr2 $ "'");

	return i >= 0;
}


function bool IsBoolStr(string s, out int boolVal) {

	if (s ~= "true")
		boolVal = int(true);
	else
	if (s ~= "false")
		boolVal = int(false);
	else
		return false;

	return true;
}



function bool SpecialPropertyHandling(Actor A, string PropName, string PropValue, out string ErrorMsg) {
const CErrorMsgTrueFalseExpected = "value TRUE or FALSE expected for property";
local string s1, s2;
local name AName;
local int i;

	ErrorMsg = "";
	if (PropName ~= "CollisionRadius")
	{
		A.SetCollisionSize(float(PropValue), A.CollisionHeight);
		if (A.CollisionRadius != float(PropValue))
			ErrorMsg = "+CollisionRadius";
		return true;
	}
	if (PropName ~= "CollisionHeight")
	{
		A.SetCollisionSize(A.CollisionRadius, float(PropValue));
		if (A.CollisionHeight != float(PropValue))
			ErrorMsg = "+CollisionHeight";
		return true;
	}
	if (PropName ~= "bCollideActors")
	{
		if (IsBoolStr(PropValue, i))
		{
			A.SetCollision(bool(i));
			if (A.bCollideActors != bool(i))
				ErrorMsg = "+bCollideActors";
		}
		else
			ErrorMsg = "value TRUE or FALSE expected for property" @ PropName;
		return true;
	}

	if (PropName ~= "bBlockActors")
	{
		if (IsBoolStr(PropValue, i))
		{
			A.SetCollision(, bool(i));
			if (A.bBlockActors != bool(i))
				ErrorMsg = "+bBlockActors";
		}
		else
			ErrorMsg = "value TRUE or FALSE expected for property" @ PropName;
		return true;
	}

	if (PropName ~= "bBlockPlayers")
	{
		if (IsBoolStr(PropValue, i))
		{
			A.SetCollision(, , bool(i));
			if (A.bBlockPlayers != bool(i))
				ErrorMsg = "bBlockPlayers";
		}
		else
			ErrorMsg = "value TRUE or FALSE expected for property" @ PropName;
		return true;
	}

	if (PropName ~= "InitialState")
	{
		A.InitialState = StringToName(PropValue);
		A.GotoState(A.InitialState);
		ErrorMsg = "";
		return true;
	}

	if (PropName ~= "GotoState")
	{
		SplitByComma(PropValue, s1, s2);
		AName = StringToName(s1);
		A.GotoState(AName, StringToName(s2));
		if ( ! IsInState(AName))
			ErrorMsg = "state could not be changed for" @ A $ ", current state=" $ A.GetStateName();
		return true;
	}
	if (PropName ~= "Log")
	{
		SplitByComma(PropValue, s1, s2);
		A.Log(s1, StringToName(s2));
		return true;
	}
	if (PropName ~= "Warn")
	{
		A.Warn(PropValue);
		return true;
	}
	if (PropName ~= "Enable")
	{
		A.Enable(StringToName(PropValue));
		return true;
	}
	if (PropName ~= "Disable")
	{
		A.Disable(StringToName(PropValue));
		return true;
	}

	return false;
}


Auto state Waiting {

begin:
	if (bDebug) DebugLog("ChangeProperties.Waiting", "entering state 'Waiting'");
	Enable('Trigger');
}



state ChangeProperties {


	function BeginState() {
		if (bDebug) DebugLog("ChangeProperties.BeginState", "entering state 'ChangeProperties'");
		if (WantedActor == '')
		{
			warn("'WantedActor' must not be NONE!" @ self @ "is terminating now.");
			GotoState('Waiting');
		}
	}



	function TreatActor(Actor A) {
	local int i;
	local string ErrorMsg;

		for (i=0; i < ArrayCount(Properties); i++)
			if (Properties[i] != "")
			{
				if (bDebug) DebugLog("ChangeProperties.TreatActor", "trying to set property '" $ Properties[i] $ "' to '" $ PropertyValues[i] $ "' for" @ A);
				if (SpecialPropertyHandling(A, Properties[i], PropertyValues[i], ErrorMsg))
				{
					if (bDebug) DebugLog("ChangeProperties.TreatActor", "SpecialPropertyHandling was done with ErrorMsg='" $ ErrorMsg $ "'");
				}
				else
				{
					A.SetPropertyText(Properties[i], PropertyValues[i]);
					if (A.GetPropertyText(Properties[i]) == PropertyValues[i])
					{
						if (bDebug) DebugLog("ChangeProperties.TreatActor", "SetPropertyText successful done");
					}
					else
						ErrorMsg = "setting property '" $ Properties[i] $ "' with value '" $ PropertyValues[i] $ "' failed, current value='" $ A.GetPropertyText(Properties[i] $ "'");
				}
				if (ErrorMsg != "")
				{
					warn(ErrorMsg);
					ErrorMsg = "";
				}
			}
	}


	function TreatActors() {
	local Actor A;
	local bool bActorFound;

		if (WantedActorSearchBy == WASB_Name)
		{
			if (FindActorByName(WantedActor, A))
				TreatActor(A);
			else
				warn("Actor with Name='" $ WantedActor $ "' not found");
		}
		else
		{
			bActorFound = false;
			ForEach AllActors(Class'Actor', A, WantedActor)
			{
				TreatActor(A);
				bActorFound = true;
			}
			if ( ! bActorFound)
				warn("No Actor with tag '" $ WantedActor $ "' found");
		}
	}

begin:
	disable('Trigger');
	TreatActors();
	if (bTriggerOnceOnly)
		GotoState('Disabled');
	else
		GotoState('Waiting');
}



state Disabled {
	ignores Trigger;

}


defaultproperties {
	bCollideActors=false
	CollisionHeight=0
	CollisionRadius=0
}


